* BEGGINING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES=year TO conex
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=NONE.

* Data modification by pseudo count method *.
COUNT nzeros1 = caex canex (0)  .
COUNT nzeros2 = coex conex (0).
DO IF (nzeros1=1 or nzeros2=1).
COMPUTE caex=caex+1/2.
COMPUTE canex=canex+1/2.
COMPUTE coex=coex+1/2.
COMPUTE conex=conex+1/2.
END IF.
EXECUTE.
RANK trial /n into N /PRINT=NO.
TEMPORARY.
SELECT IF (nzeros1<>2 and nzeros2<>2).

MATRIX.
PRINT  /TITLE=" META-ANALYSIS: ODDS-RATIO FROM RAW DATA".
PRINT /TITLE=" FIXED EFFECT MODEL: INVERSE VARIANCE (WOOLF'S METHOD)".
GET numtr /VAR=n.
GET id    /VAR=trial.
GET trial /VAR=study.
GET ai    /VAR=caex.
GET bi    /VAR=coex.
GET ci    /VAR=canex.
GET di    /VAR=conex.
* General calculations & input data report *.
COMPUTE k=NROW(ai).
COMPUTE sumai=MSUM(ai).
COMPUTE sumbi=MSUM(bi).
COMPUTE sumci=MSUM(ci).
COMPUTE sumdi=MSUM(di).
PRINT {ai,bi,ci,di;sumai,sumbi,sumci,sumdi}
 /FORMAT="F8.1"
 /RNAMES=trial
 /CLABELS="CaExp+","CoExp+","CaExp-","CoExp-"
 /TITLE='INPUT DATA (pseudo-count modified if necessary)'.
PRINT k
 /FORMAT="F8.0"
 /TITLE="Number of trials analysed (K)".
COMPUTE crudeorr=(sumai*sumdi)/(sumci*sumbi).
COMPUTE crudese=SQRT((1/sumai)+(1/sumbi)+(1/sumci)+(1/sumdi)).
COMPUTE cilowcr=crudeorr*EXP(-1.96*crudese).
COMPUTE ciupwcr=crudeorr*EXP(1.96*crudese).
PRINT {crudeorr,crudese,cilowcr,ciupwcr}
 /FORMAT="F8.2"
 /RLABELS="   Crude"
 /CLABELS="OR","SE(LNOR)","Lower","Upper"
 /TITLE='                                  95% CI'.
* Individual OR *.
COMPUTE orr=(ai&*di)&/(ci&*bi).
COMPUTE selog=SQRT((1/ai)+(1/bi)+(1/ci)+(1/di)).
COMPUTE wi=(1/selog)&**2.
COMPUTE percwi=100*wi/MSUM(wi).
COMPUTE cilow=EXP(LN(orr)-1.96&*selog).
COMPUTE ciup=EXP(LN(orr)+1.96&*selog).
* Summary OR *.
COMPUTE num=MSUM(wi&*LN(orr)).
COMPUTE den=MSUM(wi).
COMPUTE woolforr=EXP(num/den).
COMPUTE sewoolf=1/SQRT(den).
COMPUTE cilowor=EXP((num/den)-1.96*sewoolf).
COMPUTE ciupwor=EXP((num/den)+1.96*sewoolf).
* Report *.
PRINT {orr,selog,cilow,ciup,percwi}
 /FORMAT="F8.2"
 /RNAMES=trial
 /CLABELS="OR","SE(lnOR)","Lower","Upper", "Weight%"
 /TITLE='                                  95% CI'.
PRINT {woolforr,sewoolf,cilowor,ciupwor,100}
 /FORMAT="F8.2"
 /RLABELS=" Overall"
 /CLABELS="OR","SE(LNOR)","Lower","Upper", "Weight%"
 /TITLE='SUMMARY                           95% CI'.
COMPUTE a_chi=(LN(woolforr)/sewoolf)**2.
COMPUTE a_sig=1-CHICDF(a_chi,1).
PRINT {a_chi,a_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Association Chi-square statistic (df=1) - H0: No association".
COMPUTE het_chi=MSUM(wi&*((LN(orr)-LN(woolforr))&**2)).
COMPUTE het_sig=1-CHICDF(het_chi,k-1).
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Cochran Q heterogeneity test (df=K-1) - H0: Homogeneity".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
* Exporting data for forest-plot *.
COMPUTE data1={sumai,sumbi,sumci,sumdi}.
COMPUTE namevec1={"caex","coex","canex","conex"}.
SAVE data1 /OUTFILE='a:\temp\extrarow.sav' /NAMES=namevec1.
COMPUTE data2={id,orr,selog,cilow,ciup,percwi;numtr(1)+1,woolforr,sewoolf,cilowor,ciupwor,100}.
COMPUTE namevec2={"trial","orr","selog","loworr","highorr","wi"}.
SAVE data2 /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec2.
END MATRIX.

* Adding extra statistics & data to current file *.

ADD FILES /FILE=*
 /FILE='a:\temp\extrarow.sav'
 /DROP= nzeros1 nzeros2 n.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'
 /BY trial.
EXECUTE.

*  Forest plot with individual and aggregated RR *.

VAR LABEL loworr 'Lower 95%CI' /highorr 'Upper 95%CI' /orr 'OR'. 
GRAPH /HILO(SIMPLE)=VALUE( highorr loworr orr ) BY study 
 /TITLE='Fixed Effects Model' /TEMPLATE='a:\forest.sct'.
