* BEGGINING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES=year TO totnex
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=NONE.

* Data modification by pseudo count method *.
COUNT nzeros1 = evex evnex (0).
COMPUTE #bi=totex-evex.
COMPUTE #di=totnex-evnex.
COUNT nzeros2 = #bi #di (0).
DO IF (nzeros1=1 OR nzeros2=1).
COMPUTE evex=evex+1/2.
COMPUTE evnex=evnex+1/2.
COMPUTE totex=totex+1.
COMPUTE totnex=totnex+1.
END IF.
EXECUTE.
RANK trial /n INTO N /PRINT=NO.
TEMPORARY.
SELECT IF (nzeros1<>2 AND nzeros2<>2).

MATRIX.
PRINT  /TITLE=" META-ANALYSIS: RISK DIFFERENCE FROM RAW DATA".
PRINT /TITLE=" FIXED EFFECT MODEL: MANTEL-HAENSZEL METHOD".
GET id    /VAR=trial.
GET numtr /VAR=n.
GET trial /VAR=study.
GET ai    /VAR=evex.
GET ci    /VAR=evnex.
GET n1i   /VAR=totex.
GET n0i   /VAR=totnex.
* General calculations & input data report *.
COMPUTE k=NROW(id).
COMPUTE bi=n1i-ai.
COMPUTE di=n0i-ci.
COMPUTE ni=n1i+n0i.
COMPUTE sumai=MSUM(ai).
COMPUTE sumci=MSUM(ci).
COMPUTE sumbi=MSUM(bi).
COMPUTE sumdi=MSUM(di).
COMPUTE sumn1i=MSUM(n1i).
COMPUTE sumn0i=MSUM(n0i).
PRINT {ai,n1i,ci,n0i;sumai,sumn1i,sumci,sumn0i}
 /FORMAT="F8.1"
 /RNAMES=trial
 /CLABELS="Ev+EXP+","TotEXP+","Ev+EXP-","TotEXP-"
 /TITLE='INPUT DATA (pseudo-count modified if necessary)'.
PRINT k
 /FORMAT="F8.0"
 /TITLE='Number of trials analysed (K)'.
COMPUTE cruderd=(sumai&/sumn1i)-(sumci&/sumn0i).
COMPUTE crudese=SQRT(sumai&*sumbi&/(sumn1i&**3)+sumci&*sumdi&/(sumn0i&**3)).
COMPUTE crudelow=cruderd-1.96*crudese.
COMPUTE crudeup=cruderd+1.96*crudese.
PRINT {cruderd,crudese,crudelow,crudeup}
 /FORMAT="F8.3"
 /RLABELS="   Crude"
 /CLABELS="RD","SE(RD)","Lower","Upper"
 /TITLE='                                  95% CI'.
* Individual RD *.
COMPUTE rd=(ai&/n1i)-(ci&/n0i).
COMPUTE se=SQRT(ai&*bi&/(n1i&**3)+ci&*di/(n0i&**3)).
COMPUTE wi=n1i&*n0i/ni.
COMPUTE percwi=100&*wi/MSUM(wi).
COMPUTE cilow=rd-1.96&*se.
COMPUTE ciup=rd+1.96&*se.
* Summary RD *.
COMPUTE mhrd=MSUM(rd&*wi)/MSUM(wi).
COMPUTE nnt=1/ABS(mhrd).
COMPUTE p=MSUM((ai&*bi&*(n0i&**3)+ci&*di&*(n1i&**3))/(n1i&*n0i&*(ni&**2))).
COMPUTE q=MSUM(n1i&*n0i/ni).
COMPUTE mhse=SQRT(p/(q&**2)).
COMPUTE cilowrd=mhrd-1.96*mhse.
COMPUTE ciupwrd=mhrd+1.96*mhse.
* Report *.
PRINT {rd,se,cilow,ciup,percwi}
 /FORMAT="F8.3"
 /RNAMES=trial
 /CLABELS="RD","SE(RD)","Lower","Upper","Weight%"
 /TITLE='                                  95% CI'.
PRINT {mhrd,mhse,cilowrd,ciupwrd,100}
 /FORMAT="F8.3"
 /RLABELS=" Overall"
 /CLABELS="RD","SE(RD)","Lower","Upper","Weight%"
 /TITLE='MANTEL-HAENSZEL:                  95% CI'.
PRINT nnt
 /format='F8.0'
 /title='Number Needed to Treat (NNT)'.
COMPUTE wpi=(1/se)&**2.
COMPUTE a_chi=(mhrd/mhse)**2.
COMPUTE a_sig=1-CHICDF(a_chi,1).
PRINT {a_chi,a_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Association Chi-square statistic (df=1) - H0: No association".
COMPUTE het_chi=MSUM(wpi&*(rd-mhrd)&**2).
COMPUTE het_sig=1-CHICDF(het_chi,k-1).
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Cochran Q heterogeneity test (df=K-1) - H0: Homogeneity".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
* Exporting data for forest-plot *.
COMPUTE data1={sumai,sumn1i,sumci,sumn0i}.
COMPUTE namevec1={"evex","totex","evnex","totnex"}.
SAVE data1 /OUTFILE='a:\temp\extrarow.sav' /NAMES=namevec1.
COMPUTE data2={id,rd,se,cilow,ciup,percwi;numtr(1)+1,mhrd,mhse,cilowrd,ciupwrd,100}.
COMPUTE namevec2={"trial","rd","se","lowrd","highrd","wi"}.
SAVE data2 /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec2.
END MATRIX.

* Adding extra statistics & data to current file *.
ADD FILES /FILE=*
 /FILE='a:\temp\extrarow.sav'
 /DROP= nzeros1 nzeros2 n.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'
 /BY trial.
EXECUTE.

* Forest plot with individual and aggregated RD *.
VAR LABEL lowrd 'Lower 95%CI' /highrd 'Upper 95%CI' /rd 'Risk Diff.'.
GRAPH /HILO(SIMPLE)=VALUE( highrd lowrd rd ) BY study
 /TITLE='Fixed Effects Model' /TEMPLATE='a:\forest2.sct'.