* BEGGINING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES=year TO totnex
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=NONE.

* Data modification by pseudo count method *.
COUNT nzeros1 = evex evnex (0).
COMPUTE #bi=totex-evex.
COMPUTE #di=totnex-evnex.
COUNT nzeros2 = #bi #di (0).
DO IF (nzeros1=1 or nzeros2=1).
COMPUTE evex=evex+1/2.
COMPUTE evnex=evnex+1/2.
COMPUTE totex=totex+1.
COMPUTE totnex=totnex+1.
END IF.
EXECUTE.
RANK trial /N INTO n /PRINT=NO.
TEMPORARY.
SELECT IF (nzeros1<>2 and nzeros2<>2).

MATRIX.
PRINT  /TITLE=" META-ANALYSIS: RELATIVE RISK FROM RAW DATA".
PRINT /TITLE=" RANDOM EFFECTS MODEL: DERSIMONIAN-LAIRD'S METHOD".
GET numtr /VAR=n.
GET id    /VAR=trial.
GET trial /VAR=study.
GET ai    /VAR=evex.
GET ci    /VAR=evnex.
GET n1i   /VAR=totex.
GET n0i   /VAR=totnex.
* General calculations & input data report *.
COMPUTE k=NROW(id).
COMPUTE bi=n1i-ai.
COMPUTE di=n0i-ci.
COMPUTE ni=n1i+n0i.
COMPUTE sumai=MSUM(ai).
COMPUTE sumci=MSUM(ci).
COMPUTE sumn1i=MSUM(n1i).
COMPUTE sumn0i=MSUM(n0i).
PRINT {ai,n1i,ci,n0i;sumai,sumn1i,sumci,sumn0i}
 /FORMAT="F8.1"
 /RNAMES=trial
 /CLABELS="Ev+Exp+","TotExp+","Ev+Exp-","TotExp-"
 /TITLE='INPUT DATA (pseudo-count modified if necessary)'.
PRINT k
 /FORMAT="F8.0"
 /TITLE='Number of trials analysed'.
COMPUTE cruderr=(sumai/sumn1i)/(sumci/sumn0i).
COMPUTE crudese=SQRT((1/sumai)-(1/sumn1i)+(1/sumci)-(1/sumn0i)).
COMPUTE cilowcr=cruderr*EXP(-1.96*crudese).
COMPUTE ciupwcr=cruderr*EXP(1.96*crudese).
PRINT {cruderr,crudese,cilowcr,ciupwcr}
 /FORMAT="F8.2"
 /RLABELS="   Crude"
 /CLABELS="RR","SE(lnrR)","Lower","Upper"
 /TITLE='                                  95% CI'.
* Individual RR *.
COMPUTE rr=(ai&/n1i)&/(ci&/n0i).
COMPUTE var=(1/ai)-(1/n1i)+(1/ci)-(1/n0i).
COMPUTE wi=1/var.
COMPUTE selog=SQRT(var).
COMPUTE cilow=exp(LN(rr)-1.96&*selog).
COMPUTE ciup=exp(LN(rr)+1.96&*selog).
COMPUTE het_chi=MSUM(wi&*(LN(rr)-MSUM(wi&*LN(rr))/MSUM(wi))&**2).
COMPUTE het_sig=1-CHICDF(het_chi,k-1).
PRINT /TITLE='Heterogeneity before taking Tau-square into consideration'.
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Cochran Q heterogeneity test (df=K-1) - H0: Homogeneity".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
COMPUTE tau=(het_chi-(k-1))/(msum(wi)-(msum(wi&**2))/msum(wi)).
DO IF tau GT 0.
- PRINT tau
 /FORMAT="F8.3"
 /TITLE='Tau-square (between trials variance)'.
- COMPUTE vartilda=tau+var.
- COMPUTE wi=1/vartilda.
ELSE.
- PRINT /TITLE='Tau-square=0 (random- & fixed-effect models will yield'
 +' identical results)'.
END IF.
COMPUTE percwi=100&*wi/MSUM(wi).
PRINT /TITLE="INDIVIDUAL RR & TAU-SQUARE MODIFIED WEIGHTS".
* Summary RR *.
COMPUTE delairr=EXP(MSUM(wi&*LN(rr))/MSUM(wi)).
COMPUTE sedelai=1/SQRT(MSUM(wi)).
COMPUTE cilowdl=EXP(LN(delairr)-1.96*sedelai).
COMPUTE ciupdl=EXP(LN(delairr)+1.96*sedelai).
* Reports *.
PRINT {rr,selog,cilow,ciup,percwi}
 /FORMAT="F8.2"
 /RNAMES=trial
 /CLABELS="RR","SE(lnOR)","Lower","Upper","Weight%"
 /TITLE='                                  95% CI'.
DO IF tau GT 0.
- PRINT /TITLE='Dersimonian-Laird statistic:'.
END IF.
PRINT {delairr,sedelai,cilowdl,ciupdl,100}
 /FORMAT="F8.2"
 /RLABELS=" Overall"
 /CLABELS="RR","SE(lnRR)","Lower","Upper","Weight%"
 /TITLE='SUMMARY                           95% CI'.
COMPUTE a_chi=(LN(delairr)/sedelai)**2.
COMPUTE a_sig=1-CHICDF(a_chi,1).
PRINT {a_chi,a_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Association Chi-square test (df=1) - H0: No association".
* Exporting data for forest-plot *.
COMPUTE data1={sumai,sumn1i,sumci,sumn0i}.
COMPUTE namevec1={"evex","totex","evnex","totnex"}.
SAVE data1 /OUTFILE='a:\temp\extrarow.sav' /NAMES=namevec1.
COMPUTE data2={id,rr,selog,cilow,ciup,percwi;numtr(1)+1,delairr,sedelai,cilowdl,ciupdl,100}.
COMPUTE namevec2={"trial","rr","selog","lowrr","highrr","wi"}.
SAVE data2 /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec2.
END MATRIX.

* Adding extra statistics & data to current file *.

ADD FILES /FILE=*
 /FILE='a:\temp\extrarow.sav'
 /DROP= nzeros1 nzeros2 n.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'
 /BY trial.
EXECUTE.

*  Forest plot with individual and aggregated RR *.

VAR LABEL lowrr 'Lower 95%CI' /highrr 'Upper 95%CI' /rr 'RR'. 
GRAPH /HILO(SIMPLE)=VALUE( highrr lowrr rr ) BY study 
 /TITLE='Random Effects Model' /TEMPLATE='a:\forest.sct'.

