* BEGGINING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES= ALL
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=SUM .

* Data modification by pseudo count method & exclusion of invalid trials
  (RR is undefined if evex=evnex=0 or totex-evex=totnex-evnex=0).
COUNT nzeros1 = evex evnex (0).
COMPUTE #bi=totex-evex.
COMPUTE #di=totnex-evnex.
COUNT nzeros2 = #bi #di (0).
EXECUTE .
DO IF (nzeros1=1 or nzeros2=1).
COMPUTE evex=evex+1/2.
COMPUTE evnex=evnex+1/2.
COMPUTE totex=totex+1.
COMPUTE totnex=totnex+1.
END IF.
EXECUTE.
RANK trial /n into N /PRINT=NO.
TEMPORARY.
SELECT IF (nzeros1<>2 and nzeros2<>2).

MATRIX.
PRINT  /TITLE=" META-ANALYSIS: RELATIVE RISK FROM RAW DATA".
PRINT /TITLE=" FIXED EFFECT MODEL: MANTEL-HAENSZEL METHOD".
GET numtr /VAR=n.
GET id    /VAR=trial.
GET trial /VAR=study.
GET ai    /VAR=evex.
GET ci    /VAR=evnex.
GET n1i   /VAR=totex.
GET n0i   /VAR=totnex.
* General calculations & input data report *.
COMPUTE k=NROW(id).
COMPUTE bi=n1i-ai.
COMPUTE di=n0i-ci.
COMPUTE m1i=ai+ci.
COMPUTE m0i=bi+di.
COMPUTE ni=n1i+n0i.
COMPUTE sumai=MSUM(ai).
COMPUTE sumci=MSUM(ci).
COMPUTE sumn1i=MSUM(n1i).
COMPUTE sumn0i=MSUM(n0i).
PRINT {ai,n1i,ci,n0i;sumai,sumn1i,sumci,sumn0i}
 /FORMAT='F8.1'
 /RNAMES=trial
 /CLABELS='Ev+Exp+','TotExp+','Ev+Exp-','TotExp-'
 /TITLE='INPUT DATA (pseudo-count modified if necessary)'.
PRINT k
 /FORMAT='F8.0'
 /TITLE='Number of trials analysed'.
COMPUTE cruderr=(sumai/sumn1i)/(sumci/sumn0i).
COMPUTE crudese=SQRT((1/sumai)-(1/sumn1i)+(1/sumci)-(1/sumn0i)).
COMPUTE cilowcr=cruderr*exp(-1.96*crudese).
COMPUTE ciupwcr=cruderr*exp(1.96*crudese).
PRINT {cruderr,crudese,cilowcr,ciupwcr}
 /FORMAT='F8.2'
 /RLABELS='   Crude'
 /CLABELS='RR','SE(lnOR)','Lower','Upper'
 /TITLE='SUMMARY                           95% CI'.
* Individual RR *.
COMPUTE rr=(ai&/n1i)&/(ci&/n0i).
COMPUTE selog=SQRT((1/ai)-(1/n1i)+(1/ci)-(1/n0i)).
COMPUTE wi=ci&*(ai+bi)/ni.
COMPUTE percwi=100&*wi/MSUM(wi).
COMPUTE cilow=EXP(LN(rr)-1.96&*selog).
COMPUTE ciup=EXP(LN(rr)+1.96&*selog).
PRINT {rr,selog,cilow,ciup,percwi}
 /FORMAT='F8.2'
 /RNAMES=trial
 /CLABELS='RR','SE(lnRR)','Lower','Upper','Weight%'
 /TITLE='                                  95% CI'.
* Mantel-Haenszel RR *.
COMPUTE mhrr=MSUM(wi&*rr)/MSUM(wi).
COMPUTE num1=MSUM((m1i&*n1i&*n0i-ai&*ci&*ni)&/(ni&**2)).
COMPUTE den1=MSUM(ai&*n0i&/ni).
COMPUTE den2=MSUM(ci&*n1i&/ni).
COMPUTE semhrr=SQRT(num1/(den1*den2)).
COMPUTE cilowmh=mhrr*exp(-1.96*semhrr).
COMPUTE ciupwmh=mhrr*exp(1.96*semhrr).
PRINT {mhrr,semhrr,cilowmh,ciupwmh,100}
 /FORMAT='F8.2'
 /RLABELS=' Overall'
 /CLABELS='RR','SE(lnRR)','Lower','Upper','Weight%'
 /TITLE='                                  95% CI'.
COMPUTE a_chi=(LN(mhrr)/semhrr)**2.
COMPUTE a_sig=1-CHICDF(a_chi,1).
PRINT {a_chi,a_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Association Chi-square statistic (df=1) - H0: No association".
COMPUTE wpi=(1/selog)&**2.
COMPUTE het_chi=MSUM(wpi&*((LN(rr)-LN(mhrr))&**2)).
COMPUTE het_sig=1-chicdf(het_chi,k-1).
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Cochran Q heterogeneity test (df=K-1) - H0: Homogeneity".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE='WARNING: Q p>0.10, but some heterogeneity exists!'.
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT='F8.1'
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
COMPUTE data1={sumai,sumn1i,sumci,sumn0i}.
COMPUTE namevec1={'evex','totex','evnex','totnex'}.
SAVE data1 /OUTFILE='a:\temp\extrarow.sav' /NAMES=namevec1.
COMPUTE data2={id,rr,selog,cilow,ciup,percwi;numtr(1)+1,mhrr,semhrr,cilowmh,ciupwmh,100}.
COMPUTE namevec2={'trial','rr','selog','lowrr','highrr','wi'}.
SAVE data2 /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec2.
END MATRIX.

* Adding extra statistics & data to current file *.
ADD FILES /FILE=*
 /FILE='a:\temp\extrarow.sav'
 /DROP= nzeros1 nzeros2 n.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'
 /BY trial.
EXECUTE.

*  Forest plot with individual and aggregated RR *.
VAR LABEL lowrr 'Lower 95%CI' /highrr 'Upper 95%CI' /rr 'RR'. 
GRAPH /HILO(SIMPLE)=VALUE( highrr lowrr rr ) BY study 
 /TITLE='M-H Fixed Effects Model'  /TEMPLATE='a:\forest.sct'. 