* BEGGINING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES=year TO selog
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=NONE.

MATRIX.
PRINT  /TITLE ' META-ANALYSIS: SUMMARY RATIO FROM PROCESSED DATA (FIXED-EFFECT MODEL)'.
PRINT /TITLE="INVERSE VARIANCE (WOOLF'S METHOD)".
GET trial /VAR=study.
GET orr   /VAR=orr.
GET selog /VAR=selog.
* General calculations & report *.
COMPUTE k=NROW(orr).
PRINT k
 /FORMAT="F8.0"
 /TITLE="Number of trials analysed (K)".
COMPUTE wi=(1/selog)&**2.
COMPUTE percwi=100*wi&/MSUM(wi).
COMPUTE cilow=EXP(LN(orr)-1.96&*selog).
COMPUTE ciup=EXP(LN(orr)+1.96&*selog).
PRINT {orr,selog,cilow,ciup,percwi}
 /FORMAT="F8.2"
 /RNAMES=trial
 /CLABELS="OR","SE(LNOR)","Lower","Upper", "Weight%"
 /TITLE='                                  95% CI'.
* Summary OR *.
COMPUTE num=MSUM(wi&*LN(orr)).
COMPUTE den=MSUM(wi).
COMPUTE woolforr=EXP(num/den).
COMPUTE sewoolf=1/SQRT(den).
COMPUTE cilowor=EXP((num/den)-1.96*sewoolf).
COMPUTE ciupwor=EXP((num/den)+1.96*sewoolf).
PRINT {woolforr,sewoolf,cilowor,ciupwor,100}
 /FORMAT="F8.2"
 /RLABELS=" Overall"
 /CLABELS="OR","SE(LNOR)","Lower","Upper", "Weight%"
 /TITLE='SUMMARY                           95% CI'.
COMPUTE chival=wi&*((LN(orr)-LN(woolforr))&**2).
COMPUTE het_chi=MSUM(chival).
COMPUTE het_sig=1-CHICDF(het_chi,k-1).
COMPUTE a_chi=(LN(woolforr)/sewoolf)**2.
COMPUTE a_sig=1-CHICDF(a_chi,1).
* Report *.
PRINT {a_chi,a_sig}
 /FORMAT="f8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Association Chi-square statistic (df=1) - H0: No association".
PRINT {het_chi,het_sig}
 /FORMAT="f8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Cochran Q heterogeneity test (df=K-1) - H0: Homogeneity".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
* Exporting data for forest-plot *.
COMPUTE data1={woolforr,sewoolf}.
COMPUTE namevec1={"orr","selog"}.
SAVE data1 /OUTFILE='a:\temp\extrarow.sav' /NAMES=namevec1.
COMPUTE data2={cilow,ciup,percwi;cilowor,ciupwor,100}.
COMPUTE namevec2={"loworr","highorr","wi"}.
SAVE data2 /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec2.
END MATRIX.

* Adding extra statistics & data to current file *.

ADD FILES /FILE=*
 /FILE='a:\temp\extrarow.sav'.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'.
EXECUTE.

*  Forest plot with individual and aggregated RR *.

VAR LABEL loworr 'Lower 95%CI' /highorr 'Upper 95%CI' /orr 'OR'. 
GRAPH /HILO(SIMPLE)=VALUE( highorr loworr orr ) BY study 
 /TITLE='Fixed Effects Model' /TEMPLATE='a:\forest.sct'.
