* BEGINNING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES=year TO se
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=NONE.

MATRIX.
PRINT  /TITLE ' META-ANALYSIS: RISK DIFFERENCE FROM PROCESSED DATA (RANDOM-EFFECTS MODEL)'.
PRINT /TITLE="(DERSIMONIAN-LAIRD'S METHOD)".
GET trial /VAR=study.
GET rd    /VAR=rd.
GET se    /VAR=se.
* General calculations & heterogeneity report *.
COMPUTE k=NROW(rd).
COMPUTE wi=(1/se)&**2.
COMPUTE cilow=rd-1.96&*se.
COMPUTE ciup=rd+1.96&*se.
PRINT k
 /FORMAT="F8.0"
 /TITLE='Number of trials analysed (K)'.
COMPUTE het_chi=MSUM(wi&*(rd-(MSUM(wi&*rd)/MSUM(wi)))&**2).
COMPUTE het_sig=1-CHICDF(het_chi,k-1).
PRINT /TITLE='Heterogeneity before taking Tau-square into consideration'.
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Cochran Q heterogeneity test (df=K-1) - H0: Homogeneity".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
COMPUTE tau=(het_chi-(k-1))/(MSUM(wi)-(MSUM(wi&**2))/MSUM(wi)).
DO IF tau GT 0.
- PRINT tau /FORMAT='F8.3' /TITLE='Tau-square (between trials variance)'.
- COMPUTE vartilda=tau+se&**2.
- COMPUTE wi=1/vartilda.
ELSE.
- PRINT /TITLE='Tau-square=0 (random- & fixed-effect models will yield'
 +' identical results)'.
END IF.
COMPUTE percwi=100&*wi/MSUM(wi).
PRINT /TITLE="INDIVIDUAL RD & TAU-SQUARE MODIFIED WEIGHTS".
PRINT {rd,se,cilow,ciup,percwi}
 /FORMAT='F8.3'
 /RNAMES=trial
 /CLABELS="RD","SE(RD)","Lower","Upper","Weight%"
 /TITLE='                                  95% CI'.
* Summary RD *.
COMPUTE delaird=(MSUM(wi&*rd))/MSUM(wi).
COMPUTE sedelai=1/SQRT(MSUM(wi)).
COMPUTE nnt=1/ABS(delaird).
COMPUTE cilowdl=delaird-1.96*sedelai.
COMPUTE ciupdl=delaird+1.96*sedelai.
PRINT {delaird,sedelai,cilowdl,ciupdl,100}
 /FORMAT="F8.3"
 /RLABELS=" Overall"
 /CLABELS="RD","SE(RD)","Lower","Upper","Weight%"
 /TITLE='SUMMARY                           95% CI'.
PRINT nnt
 /FORMAT='F8.0'
 /TITLE='Number Needed to Treat (NNT)'.
COMPUTE a_chi=(delaird/sedelai)**2.
COMPUTE a_sig=1-CHICDF(a_chi,1).
PRINT {a_chi,a_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Association Chi-square test (df=1) - H0: No association".
* Exporting data for forest-plot *.
COMPUTE data1={delaird,sedelai}.
COMPUTE namevec1={"rd","se"}.
SAVE data1 /OUTFILE='a:\temp\extrarow.sav' /NAMES=namevec1.
COMPUTE data2={cilow,ciup,percwi;cilowdl,ciupdl,100}.
COMPUTE namevec2={"lowrd","highrd","wi"}.
SAVE data2 /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec2.
END MATRIX.

* Adding extra statistics & data to current file *.

ADD FILES /FILE=*
 /FILE='a:\temp\extrarow.sav'.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'.
EXECUTE.

* Forest plot with individual and aggregated RD *.
VAR LABEL lowrd 'Lower 95%CI' /highrd 'Upper 95%CI' /rd 'Risk Diff.'.
GRAPH /HILO(SIMPLE)=VALUE( highrd lowrd rd ) BY study
 /TITLE='Fixed Effects Model' /TEMPLATE='a:\forest2.sct'.
