* BEGGINING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES=year TO sd2
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=NONE.

MATRIX.
PRINT  /TITLE " META-ANALYSIS: STANDARDISED MEAN DIFFERENCE (HEDGES' G)".
PRINT /TITLE=" FIXED EFFECT MODEL: INVERSE VARIANCE (WOOLF'S METHOD)".
GET study /VAR=study.
GET mean1 /VAR=mean1.
GET sd1   /VAR=sd1.
GET n1    /VAR=n1.
GET mean2 /VAR=mean2.
GET sd2   /VAR=sd2.
GET n2    /VAR=n2.
* General calculations & G report *.
COMPUTE n=n1+n2.
COMPUTE k=NROW(n).
COMPUTE totaln=MSUM(n).
PRINT k
 /FORMAT="F8.0"
 /TITLE="Number of trials (K)".
PRINT totaln
 /FORMAT="F8.0"
 /TITLE="Total sample size (N)".
COMPUTE poolvar=((n1-1)&*(sd1&**2)+(n2-1)&*(sd2&**2))/(n-2) .
COMPUTE g=(mean1-mean2)/SQRT(poolvar).
COMPUTE d=g&*(1-(3/((4&*n)-9))).
COMPUTE vard=(n/(n1&*n2))+(d&**2/(2*(n-3.94))).
COMPUTE wi=1/vard.
COMPUTE percwi=100*wi/MSUM(wi).
COMPUTE sed=SQRT(vard).
COMPUTE cilow=d-1.96*sed.
COMPUTE ciup=d+1.96*sed.
COMPUTE weight_d=MSUM(d&*wi)/MSUM(wi).
COMPUTE se_d=SQRT(1/MSUM(wi)).
COMPUTE low_d=weight_d-1.96*se_d.
COMPUTE hig_d=weight_d+1.96*se_d.
PRINT {d,sed,cilow,ciup,percwi}
 /FORMAT="F8.3"
 /RNAMES=study
 /CLABELS="Hedges g" "SE(g)" "Lower" "Upper" "%Weight"
 /TITLE='                                  95% CI'.
PRINT {weight_d,se_d,low_d,hig_d,100}
 /FORMAT="F8.3"
 /RLABELS=" Overall"
 /CLABELS="Hedges g" "SE(g)" "Lower" "Upper" "%Weight"
 /TITLE='SUMMARY                           95% CI'.
DO IF ABS(weight_d) GT 0.2.
- COMPUTE ofsn=k*(ABS(weight_d/0.2)-1).
- PRINT ofsn
 /FORMAT="F8.0"
 /TITLE="Orwin's Fail Safe N for Cohen's small effect size (0.2)".
END IF.
COMPUTE weight_g=weight_d&/(1-(3/(4&*(totaln)-9))).
COMPUTE r=ABS(weight_g&/SQRT(weight_g&**2+(4&*(totaln-2)&/totaln))).
COMPUTE besd_l=0.5-r/2.
COMPUTE besd_u=0.5+r/2.
PRINT {r,besd_l,besd_u}
 /FORMAT="F8.3"
 /TITLE="Point biserial R & BESD"
 /CLABELS="R","BESD(L)","BESD(U)".
COMPUTE a_chi=(weight_d**2)*MSUM(wi).
COMPUTE a_sig=1-CHICDF(a_chi,1).
PRINT {a_chi,a_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Association Chi-square statistic (df=1) - H0: No association".
COMPUTE het_chi=MSUM(wi&*(d-weight_d)&**2).
COMPUTE het_sig=1-CHICDF(het_chi,k-1).
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Cochran Q heterogeneity test (df=K-1) - H0: Homogeneity".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
* Exporting data for forest-plot *.
COMPUTE data={d,sed,cilow,ciup,percwi;weight_d,se_d,low_d,hig_d,100}.
COMPUTE namevec={"d","sed","lowd","highd","wi"}.
SAVE data /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec.
END MATRIX.

* Adding extra statistics & data to current file *.
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
EXECUTE.

* Forest plot with individual and aggregated MD *.
VAR LABEL lowd 'Lower 95%CI' /highd 'Upper 95%CI' /d 'Mean diff.'.
GRAPH /HILO(SIMPLE)=VALUE( highd lowd d ) BY STUDY
 /TITLE='Fixed Effects Model' /TEMPLATE='a:\forest2.sct'.
