* BEGGINING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES=year TO n2
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=NONE.

MATRIX.
PRINT  /TITLE=" META-ANALYSIS: STANDARDISED MEAN DIFFERENCE (COHEN'S D)".
PRINT /TITLE " FROM SUMMARY DATA (COHEN'S D)".
PRINT /TITLE=" RANDOM EFFECTS MODEL: DERSIMONIAN-LAIRD'S METHOD".
GET study /VAR=study.
GET d     /VAR=cohend.
GET n1    /VAR=n1.
GET n2    /VAR=n2.
* General calculations & heterogeneity report *.
COMPUTE n=n1+n2.
COMPUTE k=nrow(n).
COMPUTE totaln=MSUM(n).
PRINT k
 /FORMAT="F8.0"
 /TITLE="Number of trials (K)".
PRINT totaln
 /FORMAT="F8.0"
 /TITLE="Total sample size (N)".
COMPUTE vard=(n/(n1&*n2))+(d&**2/(2*(n-2))).
COMPUTE wi=1/vard.
COMPUTE sed=SQRT(vard).
COMPUTE cilow=d-1.96*sed.
COMPUTE ciup=d+1.96*sed.
COMPUTE weight_d=MSUM(d&*wi)/MSUM(wi).
COMPUTE se_d=SQRT(1/MSUM(wi)).
COMPUTE low_d=weight_d-1.96*se_d.
COMPUTE hig_d=weight_d+1.96*se_d.
COMPUTE het_chi=MSUM(wi&*(d-weight_d)&**2).
COMPUTE het_sig=1-chicdf(het_chi,k-1).
* Report *.
PRINT /TITLE="Heterogeneity before taking Tau-square into consideration:".
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Chi-square of heterogeneity test (df=k-1)".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
COMPUTE tau=(het_chi-(k-1))/(MSUM(wi)-(MSUM(wi&**2))/MSUM(wi)).
DO IF tau GT 0.
- PRINT tau /FORMAT="F8.3" /TITLE='Tau-square (between trials variance)'.
- COMPUTE vartilda=vard+tau.
- COMPUTE wi=1/vartilda.
ELSE.
- PRINT /title='Tau-square=0 (random- & fixed-effect models will yield'
  +' identical results)'.
END IF.
COMPUTE percwi=100*wi/MSUM(wi).
COMPUTE se_d=sqrt(1/MSUM(wi)).
COMPUTE weight_d=MSUM(d&*wi)/MSUM(wi).
COMPUTE low_d=weight_d-1.96*se_d.
COMPUTE hig_d=weight_d+1.96*se_d.
COMPUTE a_chi=(weight_d**2)*MSUM(wi).
COMPUTE a_sig=1-CHICDF(a_chi,1).
PRINT /TITLE="INDIVIDUAL G & TAU-SQUARE MODIFIED WEIGHTS".
print {d,sed,cilow,ciup,percwi}
 /FORMAT="F8.3"
 /RNAMES=study
 /CLABELS="Cohen d" "SE(g)" "Lower" "Upper" "Weight%"
 /TITLE='                                  95% CI'.
PRINT {weight_d,se_d,low_d,hig_d,100}
 /FORMAT="F8.3"
 /RLABELS=" Overall"
 /CLABELS="Cohen d" "SE(g)" "Lower" "Upper" "Weight%"
 /TITLE='SUMMARY                           95% CI'.
DO IF ABS(weight_d) GT 0.2.
- COMPUTE ofsn=k*(ABS(weight_d/0.2)-1).
- PRINT ofsn
 /FORMAT="F8.0"
 /TITLE="Orwin's Fail Safe N for Cohen's small effect size (0.2)".
END IF.
COMPUTE r=ABS(weight_d&/SQRT(weight_d&**2+(4&*(totaln-2)&/totaln))).
COMPUTE besd_l=0.5-r/2.
COMPUTE besd_u=0.5+r/2.
PRINT {r,besd_l,besd_u}
 /FORMAT="F8.3"
 /TITLE="Point biserial R & BESD"
 /CLABELS="R","BESD(L)","BESD(U)".
PRINT {a_chi,a_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Association Chi-square statistic (df=1) - H0: No association".
* Exporting data for forest-plot *.
COMPUTE data={d,sed,cilow,ciup,percwi;weight_d,se_d,low_d,hig_d,100}.
COMPUTE namevec={"d","sed","lowd","highd","wi"}.
SAVE data /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec.
END MATRIX.

* Adding extra statistics & data to current file *.
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
EXECUTE.

* Forest plot with individual and aggregated effect sizes *.
VAR LABEL lowd 'Lower 95%CI' /highd 'Upper 95%CI' /d 'Mean diff.'.
GRAPH /HILO(SIMPLE)=VALUE( highd lowd d ) BY STUDY
 /TITLE='Random Effects Model' /TEMPLATE='a:\forest2.sct'.

