* BEGGINING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES=year TO sd2
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=NONE.

MATRIX.
PRINT  /TITLE ' META-ANALYSIS: WEIGHTED MEAN DIFFERENCES'.
PRINT /TITLE=" RANDOM EFFECTS MODEL: DERSIMONIAN-LAIRD'S METHOD".
GET trial /VAR=study.
GET mean1 /VAR=mean1.
GET sd1   /VAR=sd1.
GET n1    /VAR=n1.
GET mean2 /VAR=mean2.
GET sd2   /VAR=sd2.
GET n2    /VAR=n2.
* General calculations & Heterogeneity Report *.
COMPUTE k=NROW(trial).
COMPUTE n=n1+n2.
COMPUTE totaln=MSUM(n).
PRINT k
 /FORMAT="F8.0"
 /TITLE="Number of trials (K)".
PRINT totaln
 /format="F8.0"
 /title="Total sample size (N)".
COMPUTE difmean=mean1-mean2.
COMPUTE vardif=(sd1&**2/n1)+(sd2&**2/n2).
COMPUTE sed=SQRT(vardif).
COMPUTE cilow=difmean-1.96*sed.
COMPUTE ciup=difmean+1.96*sed.
COMPUTE wi=1/vardif.
COMPUTE wmd=MSUM(difmean&*wi)/MSUM(wi).
COMPUTE se_wmd=SQRT(1/MSUM(wi)).
COMPUTE het_chi=MSUM(wi&*(difmean-wmd)&**2).
COMPUTE het_sig=1-CHICDF(het_chi,k-1).
PRINT /TITLE="Heterogeneity before taking Tau-square into consideration:".
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Value" "Sig."
 /TITLE="Chi-square of heterogeneity test (df=k-1)".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
COMPUTE tau=(het_chi-(k-1))/(MSUM(wi)-(MSUM(wi&**2))/MSUM(wi)).
DO IF tau GT 0.
- PRINT tau /format="F8.3" /title='Tau-square (between trials variance)'.
- COMPUTE vartilda=vardif+tau.
- COMPUTE wi=1/vartilda.
ELSE.
- PRINT /title='Tau-square=0 (random- & fixed-effect models will yield'
  +' identical results)'.
END IF.
* Report *.
COMPUTE percwi=100&*wi/MSUM(wi).
COMPUTE wmd=MSUM(difmean&*wi)/MSUM(wi).
COMPUTE se_wmd=SQRT(1/MSUM(wi)).
COMPUTE low_d=wmd-1.96*se_wmd.
COMPUTE hig_d=wmd+1.96*se_wmd.
PRINT /TITLE="INDIVIDUAL MD & TAU-SQUARE MODIFIED WEIGHTS".
PRINT {difmean,sed,cilow,ciup,percwi}
 /FORMAT="F8.3"
 /RNAMES=trial
 /CLABELS="MeanDiff" "SE(diff)" "Lower" "Upper" "Weight%"
 /TITLE='                                  95% CI'.
PRINT {wmd,se_wmd,low_d,hig_d,100}
 /FORMAT="F8.3"
 /RLABELS=" Overall"
 /CLABELS="MeanDiff" "SE(diff)" "Lower" "Upper" "Weight%"
 /TITLE='SUMMARY                           95% CI'.
COMPUTE a_chi=(wmd**2)*MSUM(wi).
COMPUTE a_sig=1-CHICDF(a_chi,1).
PRINT {a_chi,a_sig}
 /FORMAT="F8.4"
 /CLABELS="Value" "Sig."
 /TITLE="Association Chi-square test (df=1)".
* Exporting data for forest-plot *.
COMPUTE data={difmean,sed,cilow,ciup,percwi;wmd,se_wmd,low_d,hig_d,100}.
COMPUTE namevec={"difmean","sedif","lowd","highd","wi"}.
SAVE data /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec.
END MATRIX.

* Adding extra statistics & data to current file *.
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
EXECUTE.

* Forest plot with individual and aggregated effect sizes *.
VAR LABEL lowd 'Lower 95%CI' /highd 'Upper 95%CI' /difmean 'Mean diff.'.
GRAPH /HILO(SIMPLE)=VALUE( highd lowd difmean ) BY study
 /TITLE='Random Effects Model' /TEMPLATE='a:\forest2.sct'.

