* BEGGINING OF SYNTAX *.

CACHE.
EXECUTE.

SUMMARIZE
  /TABLES=STUDY TO COR
  /FORMAT=VALIDLIST NOCASENUM TOTAL
  /TITLE='Input data'
  /MISSING=VARIABLE
  /CELLS=NONE.

MATRIX.
PRINT  /TITLE=' META-ANALYSIS OF CORRELATIONS: HEDGES-OLKIN METHOD'.
PRINT /TITLE=" RANDOM EFFECTS MODEL: DERSIMONIAN-LAIRD'S METHOD".
GET trial /VAR=study.
GET cor   /VAR=cor.
GET n     /VAR=n.
* General calculations & report *.
COMPUTE k=NROW(n).
COMPUTE totaln=MSUM(n).
PRINT k
 /FORMAT="F8.0"
 /title="Number of trials (K)".
PRINT totaln
 /FORMAT="F8.0"
 /title="Total sample size (N)".
COMPUTE zcor=0.5*LN((1+cor)/(1-cor)).
COMPUTE varcor=1/(n-3).
COMPUTE se=SQRT(varcor).
COMPUTE wi=1/varcor.
COMPUTE zcilow=zcor-1.96*se.
COMPUTE zciup=zcor+1.96*se.
COMPUTE rcilow=(EXP(2*zcilow)-1)/(EXP(2*zcilow)+1).
COMPUTE rciup=(EXP(2*zciup)-1)/(EXP(2*zciup)+1).
COMPUTE weight_z=MSUM(zcor&*wi)/MSUM(wi).
COMPUTE het_chi=MSUM(wi&*(zcor-weight_z)&**2).
COMPUTE het_sig=1-CHICDF(het_chi,k-1).
* Report *.
PRINT /title="Heterogeneity before taking Tau-square into consideration:".
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Chi-square of heterogeneity test (df=k-1)".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE h=SQRT(het_chi/(k-1)).
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
COMPUTE tau=(het_chi-(k-1))/(MSUM(wi)-(MSUM(wi&**2))/MSUM(wi)).
DO IF tau GT 0.
- PRINT tau /FORMAT="F8.3" /title='Tau-square (between trials variance)'.
- COMPUTE vartilda=varcor+tau.
- COMPUTE wi=1/vartilda.
ELSE.
- PRINT /TITLE='Tau-square=0 (random- & fixed-effect models will yield'
  +' identical results)'.
END IF.
COMPUTE percwi=100*wi/MSUM(wi).
COMPUTE weight_z=MSUM(zcor&*wi)/MSUM(wi).
COMPUTE weight_r=(EXP(2*weight_z)-1)/(EXP(2*weight_z)+1).
COMPUTE se_z=SQRT(1/MSUM(wi)).
COMPUTE low_z=weight_z-1.96*se_z.
COMPUTE wrcilow=(EXP(2*low_z)-1)/(EXP(2*low_z)+1).
COMPUTE hig_z=weight_z+1.96*se_z.
COMPUTE wrciup=(EXP(2*hig_z)-1)/(EXP(2*hig_z)+1).
COMPUTE ofsn=k*(abs(weight_r/0.2)-1).
PRINT /TITLE="(DERSIMONIAN-LAIRD'S METHOD)".
PRINT /TITLE="INDIVIDUAL R & TAU-SQUARE MODIFIED WEIGHTS".
PRINT {cor,rcilow,rciup,percwi}
 /FORMAT="F8.3"
 /RNAMES=trial
 /CLABELS="Corr.(r)","Lower","Upper","Weight%"
 /TITLE='SUMMARY                 95% CI'.
PRINT {weight_r,wrcilow,wrciup,100}
 /FORMAT="F8.3"
 /RLABELS="Overall"
 /CLABELS="Corr.(r)","Lower","Upper","Weight%"
 /TITLE='SUMMARY                 95% CI'.
DO IF ABS(weight_r) GT 0.1.
- COMPUTE ofsn=k*(ABS(weight_r/0.1)-1).
- PRINT ofsn
 /FORMAT="F8.0"
 /TITLE="Orwin's Fail Safe N for Cohen's small effect size (0.1)".
END IF.
COMPUTE a_chi=(weight_z**2)*MSUM(wi).
COMPUTE a_sig=1-CHICDF(a_chi,1).
PRINT {a_chi,a_sig}
 /FORMAT="F8.4"
 /CLABELS="Chi^2","Sig."
 /TITLE="Association Chi-square statistic (df=1) - H0: No association".
* Exporting data for forest-plot *.
COMPUTE data1={weight_r,totaln}.
COMPUTE namevec1={"cor","n"}.
SAVE data1 /OUTFILE='a:\temp\extrarow.sav' /NAMES=namevec1.
COMPUTE data2={rcilow,rciup,percwi;wrcilow,wrciup,100}.
COMPUTE namevec2={"low_r","high_r","wi"}.
SAVE data2 /OUTFILE='a:\temp\extracols.sav' /NAMES=namevec2.
END MATRIX.

* Adding extra statistics & data to current file *.
ADD FILES /FILE=*
 /FILE='a:\temp\extrarow.sav'.
IF (MISSING(trial)) study = 'Total' .
IF (MISSING(trial)) trial = $casenum .
MATCH FILES /FILE=*
 /FILE='a:\temp\extracols.sav'.
EXECUTE.

* Forest plot with individual and aggregated effect sizes *.
VAR LABEL low_r 'Lower 95%CI' /high_r 'Upper 95%CI' /cor 'Corr. coef.'.
GRAPH /HILO(SIMPLE)=VALUE( high_r low_r cor ) BY study
  /TEMPLATE='a:\forest2.sct'.

