* BEGGINING OF SYNTAX *.

SUMMARIZE
  /TABLES=study TO cor
  /FORMAT=LIST NOCASENUM TOTAL
  /TITLE='Input Data'
  /MISSING=VARIABLE
  /CELLS=NONE.

MATRIX.
PRINT  /TITLE ' META-ANALYSIS OF CORRELATIONS: SCHMIDT-HUNTER METHOD'.
GET study /VAR=study.
GET n     /VAR=n.
GET cor   /VAR=cor.
* Z transform for 95%CI *.
COMPUTE zcor=0.5*LN((1+cor)/(1-cor)).
COMPUTE se=SQRT(1/(n-3)).
COMPUTE zcilow=zcor-1.96*se.
COMPUTE rcilow=(EXP(2*zcilow)-1)/(EXP(2*zcilow)+1).
COMPUTE zciup=zcor+1.96*se.
COMPUTE rciup=(EXP(2*zciup)-1)/(EXP(2*zciup)+1).
PRINT {cor,rcilow,rciup}
 /FORMAT="f8.2"
 /CLABELS="Corr.","95%Lower","95%Upper"
 /RNAMES=study
 /TITLE="Input data".
* General calculations *.
COMPUTE totaln=MSUM(n).
COMPUTE k=NROW(n).
PRINT k
 /FORMAT="F8.0"
 /TITLE="Number of trials (K)".
DO IF k EQ 1.
- PRINT /TITLE="Only one trial. No further analyses are possible".
ELSE.
* SH method *.
- PRINT totaln
 /FORMAT="F8.0"
 /TITLE="Total sample size (N)".
- COMPUTE umeanr=MSUM(cor)/k.
- COMPUTE wmeanr=MSUM(n&*cor)/totaln.
- COMPUTE var_r=MSUM(n&*(cor-wmeanr)&**2)/totaln.
- COMPUTE var_e=((1-wmeanr**2)**2)/((totaln/k)-1).
- DO IF var_r EQ 0.
-  PRINT /TITLE="Observed Variance is Zero. No further analysis are possible".
- ELSE.
-  COMPUTE percvar=100*var_e/var_r.
-  COMPUTE var_p=var_r-var_e.
-  DO IF var_p LT 0.
-   COMPUTE var_p=0.
-   COMPUTE percvar=100.
-  END IF.
-  COMPUTE z=wmeanr/SQRT(var_r/k).
-  COMPUTE pz=2*(1-CDFNORM(ABS(z))).
-  COMPUTE rlowci=wmeanr-1.96*SQRT(var_r/k).
-  COMPUTE ruppci=wmeanr+1.96*SQRT(var_r/k).
-  COMPUTE s_res=SQRT(var_p).
-  COMPUTE rcilow=wmeanr-1.96*s_res.
-  COMPUTE rciup=wmeanr+1.96*s_res.
-  COMPUTE hetd_chi=k*var_r/var_e.
-  COMPUTE hetd_sig=1-CHICDF(hetd_chi,k-1).
-  PRINT {wmeanr,umeanr}
   /FORMAT="f10.3"
   /CLABELS="Weighted" "(Unwgt.)"
   /TITLE="Mean correlations (weighted & unweighted).".
-  PRINT {rlowci,ruppci}
   /FORMAT="F8.3"
   /CLABELS="Lower","Upper"
   /TITLE="95% Confidence Interval for WMC".
-  PRINT {z,pz}
   /FORMAT="F8.3"
   /CLABELS="Value" "Sig."
   /title="Z Test of association for WMC. H0: No association (rho=0)".
-  PRINT var_r
   /FORMAT="F8.4"
   /TITLE="Observed variance across studies".
-  PRINT var_e
   /FORMAT="F8.4"
   /TITLE="Variance due to sampling error".
-  PRINT var_p
   /FORMAT="F8.4"
   /TITLE="Variance in the population correlations (VARp)".
-  DO IF var_p NE 0.
-   PRINT {rcilow,rciup}
    /FORMAT="F8.3"
    /CLABELS="Lower","Upper"
    /TITLE="95% Credibility Interval for WMC (based in VARp)".
-  END IF.
-  PRINT /TITLE="Indicators of homogeneity/heterogeneity:".
-  PRINT {s_res,ABS(wmeanr/4)}
   /FORMAT="F12.3"
   /CLABELS="Res SD" "1/4 WMC"
   /TITLE="  1. Residual standard deviation (should be smaller than 1/4 WMC)".
-  PRINT percvar
   /FORMAT="F12.2"
   /TITLE="  2. % Obs. variance accounted for by sampling error"
   + " (should be at least 75%)".
-  PRINT {hetd_chi,hetd_sig}
   /FORMAT="F12.4"
   /CLABELS="Value" "Sig"
   /TITLE="  3. Chi-square test of heterogeneity (df=k-1)".
- END IF.
END IF.
END MATRIX.
