* BEGGINING OF SYNTAX *.

COMPUTE zscore=IDF.NORMAL(1-pvals,0,1).
EXECUTE.
MATRIX.
PRINT  /TITLE '         META-ANALYSIS: COMBINATION OF ONE-TAILED P-VALUES'.
* Get data *.
GET trial  /VAR=study.
GET pvals  /VAR=pvals.
GET zscore /VAR=zscore.
GET wi     /VAR=weights.
* General calculations & input data report *.
COMPUTE k=NROW(pvals).
COMPUTE totaln=MSUM(wi).
PRINT pvals
 /FORMAT="F8.4"
 /TITLE="One-tailed P-values to be combined"
 /RNAMES=trial.
PRINT k
 /FORMAT="F8.0"
 /TITLE="Number of trials analysed (K)".
PRINT totaln
 /FORMAT="F8.0"
 /TITLE="Total sample size (N)".
* Heterogeneity test *.
COMPUTE meanz=MSUM(zscore)/k.
COMPUTE het_chi=MSUM((zscore-meanz)&**2).
COMPUTE het_sig=1-CHICDF(het_chi,k-1).
PRINT {het_chi,het_sig}
 /FORMAT="F8.4"
 /CLABELS="Value","Sig."
 /TITLE="Heterogeneity Chi-square (df=K-1). H0: Homogeneity".
DO IF het_chi GT (k-1).
- DO IF het_sig GT 0.10.
-  PRINT /TITLE="WARNING: Q p>0.10, but some heterogeneity exists!".
- END IF.
- COMPUTE isqr=100*(het_chi-(k-1))/het_chi.
- COMPUTE h=SQRT(het_chi/(k-1)).
- DO IF het_chi GT k.
-  COMPUTE eeh=LN(h)/(SQRT(2*het_chi)-SQRT(2*k-3)).
- ELSE IF het_chi LE k.
-  COMPUTE eeh=SQRT((1-(1/(3*(k-2)**2)))/(2*(k-2))).
- END IF.
- COMPUTE lowh=h*EXP(-1.96*eeh).
- COMPUTE upph=h*EXP(1.96*eeh).
- COMPUTE lowisqr=100*(lowh**2-1)/(lowh**2).
- DO IF lowisqr LT 0.
-  COMPUTE lowisqr=0.
- END IF.
- COMPUTE uppisqr=100*(upph**2-1)/(upph**2).
- DO IF uppisqr GT 100.
-  COMPUTE uppisqr=100.
- END IF.
- PRINT {isqr,lowisqr,uppisqr}
 /FORMAT="F8.1"
 /CLABELS='I^2(%)','Low95 CI','Upp95 CI'
 /TITLE='Heterogeneity statistic: 25%(low), 50%(moderate), 75%(high)'.
END IF.
* Fisher's, Stouffer's & Mudholkhar-George's methods *.
COMPUTE fish_chi=-2*MSUM(LN(pvals)).
COMPUTE fish_sig=1-CHICDF(fish_chi,2*k).
PRINT {fish_chi,fish_sig,(2*fish_sig)}
 /FORMAT="F8.4"
 /CLABELS="Chi2(2K)","1-tail P","2-tail P"
 /TITLE="FISHER's method (based on the product of the P values)".
COMPUTE c_term=SQRT((15*k+12)/((5*k+2)*k*3.14159265**2)).
COMPUTE mg_t=-c_term*MSUM(LN(pvals/(1-pvals))).
COMPUTE mgpvalue=1-TCDF(mg_t,5*k+4).
COMPUTE mgpvalu2=2*mgpvalue.
DO IF mgpvalu2 GT 1.
- COMPUTE mgpvalu2=1.
END IF.
PRINT {mg_t,mgpvalue,mgpvalu2}
 /FORMAT="F8.4"
 /CLABELS="t(5K+4)","1-tail P","2-tail P"
 /TITLE="MUDHOLKAR & GEORGE's method (based on logits of P values)".
COMPUTE stoufz=MSUM(zscore)/SQRT(k).
COMPUTE pvalue=1-CDFNORM(stoufz).
COMPUTE pvalue2=2*pvalue.
DO IF pvalue2 GT 1.
- COMPUTE pvalue2=1.
END IF.
COMPUTE eff_r=stoufz/SQRT(totaln).
COMPUTE besd1l=0.5-(eff_r/2).
COMPUTE besd1u=0.5+(eff_r/2).
COMPUTE wstoufz=MSUM(wi&*zscore)/SQRT(MSUM(wi&**2)).
COMPUTE wpvalue=1-CDFNORM(wstoufz).
COMPUTE wpvalue2=2*wpvalue.
DO IF wpvalue2 GT 1.
- COMPUTE wpvalue2=1.
END IF.
COMPUTE eff_wr=wstoufz/SQRT(totaln).
COMPUTE besd2l=0.5-(eff_wr/2).
COMPUTE besd2u=0.5+(eff_wr/2).
COMPUTE wrstoufz=MSUM(SQRT(wi)&*zscore)/SQRT(MSUM(wi)).
COMPUTE wrpvalue=1-CDFNORM(wrstoufz).
COMPUTE wrpvalu2=2*wrpvalue.
DO IF wrpvalu2 GT 1.
- COMPUTE wrpvalu2=1.
END IF.
COMPUTE eff_wrr=wrstoufz/SQRT(totaln).
COMPUTE besd3l=0.5-(eff_wrr/2).
COMPUTE besd3u=0.5+(eff_wrr/2).
PRINT /TITLE="STOUFFER's method (based on Z values)".
PRINT {stoufz,pvalue,pvalue2,eff_r,besd1l,besd1u}
 /FORMAT="F8.4"
 /CLABELS="Z","1-tail P","2-tail P","ES(r)","BESD(L)","BESD(U)"
 /TITLE="  * Unweighted".
DO IF totaln NE k.
- PRINT {wstoufz,wpvalue,wpvalue2,eff_wr,besd2l,besd2u}
 /TITLE="  * Weighted by weighting factors"
 /FORMAT="F8.4"
 /CLABELS="Z","1-tail P","2-tail P","ES(r)","BESD(L)","BESD(U)".
- PRINT {wrstoufz,wrpvalue,wrpvalu2,eff_wrr,besd3l,besd3u}
 /TITLE="  * Weighted by square roots of weighting factors"
 /FORMAT="F8.4"
 /CLABELS="Z","1-tail P","2-tail P","ES(r)","BESD(L)","BESD(U)".
END IF.
DO IF totaln LE k.
- PRINT /TITLE="No sample sizes were given, ignore ES(r) & BESD".
END IF.
* Fail safe N methods *.
COMPUTE fsn5=(MSUM(zscore/1.645))**2-k.
DO IF fsn5 LE 0.
- COMPUTE fsn5=0.
END IF.
COMPUTE fsn1=(MSUM(zscore/2.326))**2-k.
DO IF fsn1 LE 0.
- COMPUTE fsn1=0.
END IF.
COMPUTE a=0.01177.
COMPUTE b=-0.217*MSUM(zscore)-2.70554.
COMPUTE c=(MSUM(zscore))**2-2.70554*k.
COMPUTE fsnwc5=(-b-SQRT(b**2-4*a*c))/(2*a).
DO IF fsnwc5 le 0.
- COMPUTE fsnwc5=0.
END IF.
COMPUTE a=0.0007236.
COMPUTE b=-0.0538*MSUM(zscore)-5.4119.
COMPUTE c=(MSUM(zscore))**2-5.4119*k.
COMPUTE fsnwc1=(-b-SQRT(b**2-4*a*c))/(2*a).
DO IF fsnwc1 le 0.
+ COMPUTE fsnwc1=0.
END IF.
DO IF fsn5 GT 0.
- PRINT /TITLE="FAIL-SAFE N (for Stouffer's Unweighted 1-tail P):".
- PRINT fsn5
 /TITLE="  * Number of non-significant results needed to push P above 0.05"
 /FORMAT="F10.0".
- PRINT fsnwc5
 /TITLE="  * Worst case calculation"
 /FORMAT="F10.0".
- PRINT fsn1
 /TITLE="  * Number of non-significant results needed to push P above 0.01"
 /FORMAT="F10.0".
- PRINT fsnwc1
 /TITLE="  * Worst case calculation"
 /FORMAT="F10.0".
END IF.
END MATRIX.