* Example #1 (pvalues & binary outcomes, homogeneous trials).

DATA LIST LIST /trial(F4.0) year(A5) study(A10) mabtype(F4.0) firsttra(F4.0) age(F8.0)
 pvals(F8.4) evex(F8.0) totex(F8.0) evnex(F8.0) totnex(F8.0).
BEGIN DATA
 1 1991 Kirkman    1 1 44 0.0126 14  40 24  40
 2 1995 vanGelder  1 1 44 0.0687  3  27  8  30
 3 1997 Nashan     2 1 48 0.0035 51 171 73 166
 4 1999 Kahan      2 1 47 0.0077 57 173 79 173
 5 2000 Lawen      2 2 45 0.0624  9  59 17  64
 6 2001 Ponticelli 2 2 45 0.0108 31 168 50 172
 7 1998 Vincenti   3 1 45 0.0111 28 126 47 134
 8 1999 Nashan     3 1 44 0.0004 39 140 63 133
END DATA.

DOCUMENT 'Adu et al, BMJ 2003;326:789 Interleukin-2 receptor monoclonal
          antibodies in renal transplantation: meta-analysis of randomized
          trials (Fig 1)'.

VAR LABEL trial 'Trial ID number' /year 'Publication year' /study 'Trial ID name'
 /mabtype 'Type of Antibody' /firsttra 'Only patients with 1st trasplant' 
 /age 'Mean-Median age (years)'/pvals 'One tailed p-values'
 /evex 'Events (acute rejections) in treated group' /totex 'Total N treated group'
 /evnex 'Events (acute rejections) in control group' /totnex 'Total N control group'
VALUE LABELS mabtype  1 'MurinelgG2a/G1' 2 'Basiliximab' 3 'Daclizumab'.
VALUE LABELS firsttra 1 'Yes' 2 'No'.

COMPUTE weights=totex+totnex.
FORMAT weights (F8.0).
SAVE OUTFILE='A:\MetaDataset(I).sav'.

* Example #2 (pvals & binary outcomes, heterogeneous trials).

DATA LIST LIST /trial(F4.0) year(A5) study(A10) monoter(F4.0) pvals(F8.4)
 evex(F8.0) totex(F8.0) evnex(F8.0) totnex(F8.0).
BEGIN DATA
 1 1994 Au         1 0.5000    0  26   0  24
 2 1992 Corneliss  1 0.6057    9  47   8  47
 3 1998 Dincol     1 0.7729    5  71   3  72
 4 1994 Kojima     1 0.6299   13  36  11  34
 5 1992 Leyland    1 0.0003   31 164  53 148
 6 1990 Lieschke   1 0.9355   55  90  46  92
 7 1989 Liu        1 0.9021    4  10   2  18
 8 1987 Norrby     1 0.8106   73 105  67 105
 9 1999 Ozyilkan   1 0.7586    2  15   0  15
10 1995 Perez      1 0.2433    4  30   6  30
11 2001 Agaoglu    2 0.9617    3  30   0  57
12 1999 Akove      2 0.4582    8  40   9  43
13 1998 Behre      2 .00004   13  39  31  39
14 1996 Cornetta   2 0.5422  151 516 148 511
15 1997 DelaCamara 2 0.4176   54  62  53  60
16 1983 DePauw     3 0.5262    1  42   2  45
17 1994 DePauw     3 .000001  76 551 134 535
18 1983 Doyen      3 0.2841    3  50   6  54
19 1989 Gibson     3 0.0009   34  52  45  50
20 1993 Jacobs     3 0.1180    3  53   0  54
21 1991 Marie      3 0.4147    7  77   7  69
22 1983 Morgan     3 0.4800    0  26   1  24
23 1991 Novakova   3 0.6211    7  45   5  45
24 1988 Piguet     3 0.3934    3  82   5  87
25 1983 Alanis     4 0.1536   19  53  25  55
26 1985 Bezwoda    4 0.0545    9  29  17  31
27 1988 Hansen     4 0.5000    0  14   0  19
28 1984 Pegram     4 0.0691    5  72  10  68
29 1983 Pickard    4 0.5000    9  40   9  40
30 1998 Hess       5 0.6677   17  48  15  48
31 1984 Piccart    5 0.5000    0  25   0  24
32 1990 Smith      5 0.4546    1  47   2  53
33 2002 Tamura     5 0.9410   20  77  12  76
34 1997 Yamamura   5 0.0090   12  56  23  55
END DATA.

DOCUMENT 'Paul et al, BMJ 2003;326:1111  lactam monotherapy versus  lactam
          -aminoglycoside combination therapy for fever with neutropenia:
          systematic review and meta-analysis (Fig 5)'.

VAR LABEL trial 'Trial ID number' /year 'Publication year' /study 'Trial ID name'
 /monoter 'Monotherapy used' /pvals 'One tailed p-values'
 /evex 'Adverse events in treated group' /totex 'Total N treated group'
 /evnex 'Adverse events in control group' /totnex 'Total N control group'.
VALUE LABELS monoter  1 'Imipenem' 2 'Meropenem' 3 'Ceftazidime'
 4 'Moxalactan' 5 'Other monoth.'.

COMPUTE weights=totex+totnex.
EXECUTE.
FORMAT weights (F8.0).
SAVE OUTFILE='A:\MetaDataset(II).sav'.

* Example #3 (binary outcomes, some heterogeneity, but not significant).

DATA LIST LIST /trial(F4.0) study(A11) year(A5) totex(F8.0) evex(F8.0) totnex(F8.0) evnex(F8.0).
BEGIN DATA
 1 Reynolds     1972   38   3   39   3 
 2 Wilhemsson   1974  114   7  116  14 
 3 Ahlmark      1974   69   5   93  11 
 4 MIS          1977 1533 102 1520 127 
 5 Baber        1980  355  28  365  27 
 6 Ahnve        1980   59   4   52   6 
 7 NorwegianMC  1981  945  98  939 152 
 8 Taylor       1982  632  60  471  48 
 9 Hansteen     1982  278  25  282  37 
10 BHAT         1982 1916 138 1921 188 
11 Julian       1982  873  64  583  52 
12 Austr&Swed   1983  263  45  266  47 
13 MangerCats   1983  291   9  293  16 
14 EIS          1984  858  57  883  45 
15 Olsson       1985  154  25  147  31 
16 LIT          1987 1195  65 1200  62 
17 Boissel      1990  298  17  309  34
END DATA.

DOCUMENT 'Egger & Smith, BMJ 1997;315:1533 Meta-analysis: Principles
          and procedures (Fig 1, mortality after myocardial infarction)'.

VAR LABEL trial 'Trial ID number' /year 'Publication year' /study 'Trial ID name'
 /evex 'Mortality in treated (-blockers) group' /totex 'Total N treated group'
 /evnex 'Mortality in control group' /totnex 'Total N control group'.

COMPUTE caex=evex.
COMPUTE coex=totex-evex.
COMPUTE canex=evnex.
COMPUTE conex=totnex-evnex.
EXECUTE.
FORMAT caex TO conex (F8.0).
SAVE OUTFILE='A:\MetaDataset(III).sav'.

* Example #4 (summary data & observational studies, adjusted OR from
  logistic regression, some heterogeneity but not significant).

DATA LIST LIST /trial(F4.0) year(A5) study(A11) nevents(F8.0)
 cohsize(F8.0) orr(F8.2) selog(F8.3).
BEGIN DATA
 1 1997 Evans      240 12866 0.89 0.120
 2 2001 Knekt(ND)  347  5309 0.97 0.242
 3 1994 Alfthan    191  7424 1.00 0.146
 4 2001 Fallon     312  2290 1.13 0.090
 5 1999 Whincup    386  7735 1.15 0.067
 6 1998 Stehouwer   98   878 1.19 0.191
 7 1998 Folsom     232 15792 1.21 0.268
 8 1999 Ridker      85 28263 1.24 0.112
 9 1998 Wald       229 21520 1.26 0.064
10 1992 Stampfer   271 14916 1.29 0.135
11 1999 Kark       135  1788 1.33 0.093
12 1999 Bots       104  7983 1.34 0.108
13 1995 Arnesen    122 10963 1.42 0.160
14 2001 Vollset     88  4766 1.51 0.121
15 1997 Nygard      64   802 1.55 0.163
16 2001 Knekt(D)   240  1641 1.73 0.235
END DATA.

DOCUMENT 'Wald et al, BMJ 2002;325:1202 Homocysteine and cardiovascular
          disease: evidence on causality from a meta-analysis
          (Fig 2, prospective studies on ischemic heart disease)'.

VAR LABEL trial 'Trial ID number' /study 'Trial ID name'
 /nevents 'No of events' /cohsize 'Cohort size'  
 /year 'Publication year' /orr 'Odds Ratio' /selog 'se(logOR)'.
SAVE OUTFILE='A:\MetaDataset(IV).sav'.

* Example #5 (continuous outcomes, some heterogeneity, but not significant).

DATA LIST LIST /trial(F4.0) year(A5) study(A10) n1(F8.0) mean1(F8.2) sd1(F8.2)
 n2(F8.0) mean2(F8.2) sd2(F8.2).
BEGIN DATA
1 1998	Avdeev   27 24.00 6.00 29 28.00 6.00
2 1995	Brochard 39 28.00 8.00 42 33.00 7.00
3 1998	Celikel  15 24.00 6.00 12 30.00 5.00
4 2002	Dikensoy 17 26.00 6.60 17 31.00 6.20
5 2000	Plant    92 25.45 5.39 90 27.19 5.39
END DATA.

DOCUMENT 'Lightowler et al, BMJ 2003;326:185 Non-invasive positive pressure
          ventilation to treat respiratory failure resulting from exacerbations
          of chronic obstructive pulmonary disease: Cochrane systematic review
          and meta-analysis (Fig 3)'.

VAR LABEL trial 'Trial ID number' /year 'Publication year' /study 'Trial ID name'
 /n1 'Total N treated (NPPV) group' /mean1 'Mean of treated (NPPV) group'
 /sd1 'Std dev of treated (NPPV) group' /n2 'Total N control group'
 /mean2 'Mean of control group' /sd2 'Std dev of control group'
 /difmean 'Resp. rate (breaths/min) Mean diff.' /se 'se(dif)'
 /cohend 'Effect size (Cohen`s d)'.
SAVE OUTFILE='A:\MetaDataset(V).sav'.

* Example #6 (continuous outcomes, outcome measured in different scales, SMD needed).

DATA LIST LIST /trial(F4.0) year(A5) study(A11) method(F8.0) n1(F8.0) mean1(F8.2)
 sd1(F8.2) n2(F8.0) mean2(F8.2) sd2(F8.2).
BEGIN DATA
 1 1993 Dietemann  	1 11  67.88  11.28 12  75.37  10.46
 2 1990 Reiser     	1 23  92.00  20.00 23 100.00  18.00
 3 1986 Walshaw    	2 22 407.00 112.00 20 369.00 114.00
 4 1991 Antonicelli	3  9 443.00 106.00  9 445.00 117.00
 5 1976 Burr       	3 32 335.00 111.00 32 329.00 118.00 
 6 1980 Mitchell   	3 10  67.00  15.00 10  64.30  12.70 
 7 1994 Warburton  	3 12 350.00 101.00 12 344.00  97.00 
 8 1993 Warner     	3 14 232.60  88.00 14 231.30  97.00 
 9 1996 Carswell   	4 23  99.60  17.80 26  98.90  14.50 
10 1988 Dorwald    	4  9 388.00 106.00  9 392.00  71.00
END DATA.

DOCUMENT 'Gtzsche et al, BMJ 1998;317:1105 House dust mite control measures
          in the management of asthma: meta-analysis (Fig 3)'.

VAR LABEL trial 'Trial ID number' /year 'Publication year' /study 'Trial ID name'
 /n1 'Total N treated group' /mean1 'Mean of PEFR in treated group'
 /sd1 'Std dev of treated group' /n2 'Total N control group'
 /mean2 'Mean of of PEFR in control group' /sd2 'Std dev of control group'.

VALUE LABELS method 1 'Chemical' 2 'Physical (parallel group)'
 3 'Physical (crossover)' 4 'Combination'.
SAVE OUTFILE='A:\MetaDataset(VI).sav'.

* Example #7 (correlations, homogeneous). 

DATA LIST LIST /trial(F4.0) study(A10) n(F8.0) cor(F8.2) alpha(A6) habitat(F8.0)
group(F8.0) reserve(F8.0).
BEGIN DATA
 1 Study01 23	0.26 >0.05 2	2 2
 2 Study02 21	0.29 >0.05 2	3 2
 3 Study03 74	0.25 <0.05 2	1 2
 4 Study04 26	0.45 <0.05 3	1 1
 5 Study05 61	0.29 <0.05 2	2 2
 6 Study06 74	0.44 <0.05 1	3 1
 7 Study07 34	0.12 >0.05 4	1 2
 8 Study08 47	0.22 >0.05 3	3 2
 9 Study09 72	0.19 >0.05 4	1 1
10 Study10 60	0.20 >0.05 3	3 1
11 Study11 38	0.17 >0.05 4	1 2
12 Study12 59	0.10 >0.05 2	2 1
13 Study13 37	0.19 >0.05 2	2 1
14 Study14 32	0.31 >0.05 1	3 1
15 Study15 63	0.31 <0.05 3	2 1
16 Study16 56	0.00 >0.05 2	3 2
17 Study17 76	0.28 <0.05 4	1 1
18 Study18 37	0.29 >0.05 1	1 1
19 Study19 35	0.19 >0.05 2	2 1
20 Study20 51	0.32 <0.05 1	1 1
END DATA.

DOCUMENT 'Hunter and Schmidt (1990): Methods of meta-analysis:
  Correcting error and bias in research findings, Newbury
  Park, CA: Sage'.

VAR LABEL trial 'Trial ID' /study 'Trial name' /alpha 'Significance'
/habitat 'Type of habitat studied' /group 'Group of organisms studied'
/reserve 'Study carried out on a nature reserve'
/cor 'Pearson`s correlation coefficient' /n 'Sample size'.

VALUE LABELS habitat 1 'Deciduous Forest' 2 'Conifer Forest'
 3 'Grassland' 4 'Parkland'/group 1 'Birds' 2 'Insects'
 3 'Flowering plants'/reserve 1 'Yes'  2 'No'.

COMPUTE zscore=sqrt(n-3)*0.5*ln((1+cor)/(1-cor)).
COMPUTE pvals = 1-CDFNORM(zscore).
COMPUTE weights=n.
FORMAT weights (F8.0).
FORMAT pvals(F8.4).
EXECUTE.
SAVE OUTFILE='A:\MetaDataset(VII).sav'.

* Example #8 (correlations, heterogeneous without moderator variables). 

DATA LIST LIST /trial(F4.0) study(A10) n(F8.0) cor(F8.2).
BEGIN DATA
1 Study#1 131 0.51
2 Study#2 129 0.48
3 Study#3 155 0.30
4 Study#4 121 0.21
5 Study#5 111 0.60
6 Study#6 119 0.46
7 Study#7 112 0.22
8 Study#8 145 0.25
END DATA.

DOCUMENT 'Relationship between drug abuse and delinquency
          From META manual, by Ralph Schwarzer'.

VAR LABEL trial 'Trial ID' /study 'Trial name' 
 /cor 'Pearson`s correlation coefficient' /n 'Sample size'.
SAVE OUTFILE='A:\MetaDataset(VIII).sav'.

COMPUTE zscore=sqrt(n-3)*0.5*ln((1+cor)/(1-cor)).
COMPUTE pvals = 1-CDFNORM(zscore).
COMPUTE weights=n.
FORMAT weights (F8.0).
FORMAT pvals(F8.4).
EXECUTE.

* Example #9 (correlations, heterogeneous with moderator variables). 

DATA LIST LIST /trial(F4.0) study(A10) deftype(F8.0) defense(F8.0) fitness(F8.0)
herbivor(F8.0) control(F8.0) cor(F8.4) n(F8.0).
BEGIN DATA
 1 ref#2  2 2	2 2 2  0.13  304
 2 ref#3  2 2	2 2 2  0.17   98
 3 ref#3  2 2	2 2 2  0.26   28
 4 ref#4  2 2	2 1 2 -0.23   17
 5 ref#5  1 2	2 1 2 -0.11  885
 6 ref#6  1 2	2 2 2  0.09  260
 7 ref#6  2 1	2 1 2 -0.35   50
 8 ref#6  2 1	2 2 2  0.05  241
 9 ref#8  1 1	2 2 1 -0.50   20
10 ref#8  1 1	1 2 1 -0.43   20
11 ref#8  2 1	2 2 1 -0.49   36
12 ref#8  2 1	1 2 1 -0.26   36
13 ref#9  2 1	2 1 1 -0.66   10
14 ref#9  2 1	2 1 1 -0.66   10
15 ref#24 2 2	1 1 2 -0.08   32
16 ref#46 1 2	1 1 2  0.15  120
17 ref#46 1 2	1 1 2 -0.11  120
18 ref#46 1 2	2 1 2  0.28  120
19 ref#46 1 2	2 1 2  0.40  120
20 ref#67 2 1	2 1 2 -0.15   18
21 ref#67 2 1	2 1 2  0.01   16
END DATA.

DOCUMENT 'Koricheva, Ecology 2002;83:176 Meta-analysis of sources of
          variation in fitness costs of plant antiherbivore defenses
          (21 data from the 137 correlation coefficients extracted from
          70 studies, only part of the moderator variables are included).

VAR LABEL trial 'Trial ID' /study 'Reference' /deftype 'Defense type'
/defense 'Nature of defense measure' /fitness 'Fitness measure'
/herbivor 'Presence of herbivore'
/control 'Control for variation in experiments'
/cor 'Pearson`s correlation coefficient' /n 'N - sample size'.

VALUE LABELS deftype 1 'Constitutive' 2 'Induced'
 /defense 1 'Chemical (Alkaloids)' 2 'Other'
 /fitness 1 'Growth measures' 2 'Reproduction measures'
 /herbivor 1 'Absent' 2 'Present'
 /control 1 'Genetic' 2 'Environmental'.

COMPUTE zscore=sqrt(n-3)*0.5*ln((1+cor)/(1-cor)).
COMPUTE pvals = 1-CDFNORM(zscore).
COMPUTE weights=n.
FORMAT weights (F8.0).
FORMAT pvals(F8.4).
EXECUTE.
SAVE OUTFILE='A:\MetaDataset(IX).sav'.

* Example #10 (binary outcomes, quite heterogeneous trials).

DATA LIST LIST /trial(F4.0) study(A10) year(A5) evex(F8.0) totex(F8.0) evnex(F8.0) totnex(F8.0).
BEGIN DATA
1	Oker-Blom 	1970 	16	141	41	152
2	Muldoon   	1976 	1	53	8	52
3	Monto     	1979 	8	136	28	139
4	Kantor    	1980 	9	59	9	51
5	Pettersson	1980 	32	95	59	97
6	Quarles   	1981 	15	107	20	99
7	Dolin     	1982 	2	113	27	132
8	Reuman    	1989 	3	317	5	159
END DATA.

Document 'Jefferson TO, Demicheli V, Deeks JJ, Rivetti D. Amantadine and rimanta
          for preventing and treating influenza A in adults. Cochrane Database
          Syst Rev 2002;(4):CD001169'.

VAR LABEL evex 'Events (influenza) in treated group' /totex 'Total N treated group'
 /evnex 'Events (influenza) in control group' /totnex 'Total N control group'.

SAVE OUTFILE='A:\MetaDataset(X).sav'.

* Example #11 (continuous outcomes, fictious data, Cohen's d as input).

DATA LIST LIST /trial(F4.0) year(A5) study(A10) cohend(F8.3) n1(F8.0) n2(F8.0).
BEGIN DATA
1	1981	Study#1 	.554	17	16
2	1982	Study#2 	.373	15	15
3	1983	Study#3 	-.341	14	16
4	1984	Study#4 	.783	23	27
5	1985	Study#5 	.346	10	11
6	1986	Study#6 	-.926	12	12
7	1987	Study#7 	-.541	34	33
8	1988	Study#8 	.405	20	20
9	1989	Study#9 	.466	18	18
10	1990	Study#10	-.045	18	17
11	1991	Study#11	.892	15	14
12	1992	Study#12	.867	15	15
13	1993	Study#13	1.288	21	21
14	1994	Study#14	-.869	20	19
15	1995	Study#15	-1.181	13	12
16	1996	Study#16	1.634	18	18
17	1997	Study#17	1.499	20	20
18	1998	Study#18	-1.178	14	15
19	1999	Study#19	1.459	28	28
20	2000	Study#20	-.636	26	25
END DATA.

SAVE OUTFILE='A:\MetaDataset(XI).sav'.

* Example #12 (binary outcomes),
  from the book 'Systematic Reviews in Health Care', BMJ Books *.

DATA LIST LIST/trial(F4.0) year(A5) study(A10)
 evex(F8.0) totex(F8.0) evnex(F8.0) totnex(F8.0).
BEGIN DATA
1	1992 	Brart-Fr 	55	133	62	131
2	1992 	Brart-Bg 	281	656	319	664
3	1997 	Gagnon    	139	209	142	204
4	1989 	Hodnett   	30	72	43	73
5	1991 	Kennell   	24	212	55	200
6	1998 	Langer    	205	361	303	363
END DATA.
DOCUMENT 'Rates of use of epidural anaesthesia in trials of caregiver support
          From p 303 of Systematic Reviews in Health Care, BMJ Books'.

VAR LABEL trial 'Trial ID number' /year 'Publication year' /study 'Trial ID name'
 /evex 'Events (epidurals) in caregiver group' /totex 'Total N caregiver group'
 /evnex 'Events (epidurals) in standard care group' /totnex 'Total N standard care group'.

SAVE OUTFILE='A:\MetaDataset(XII).sav'.

* Example #13 (continuous outcomes),
  from the book 'Systematic Reviews in Health Care', BMJ Books *.

DATA LIST LIST /trial(F4.0) year(A5) study(A13) n1(F8.0) mean1(F8.2) sd1(F8.2)
 n2(F8.0) mean2(F8.2) sd2(F8.2).
BEGIN DATA
1 1996 Audini-London  30  41.4 14.0 28  42.3 12.4
2 1997 Morse-StLouis  37  0.95 0.76 35  0.89 0.65
3 1998 Lehman-Baltim  67 -4.10 0.83 58 -3.80 0.87
END DATA.

VAR LABEL trial 'Trial ID number' /year 'Publication year' /study 'Trial ID name'
 /n1 'Total N ACT group' /mean1 'Mean of mental state in ACT group'
 /sd1 'Std dev of ACT group' /n2 'Total N control group'
 /mean2 'Mean of of mental state in control group' /sd2 'Std dev of control group'.

SAVE OUTFILE='A:\MetaDataset(XIII).sav'.
