* This file explains the use of the different methods *.

*****************************************************************
*                 META-ANALYSIS OF P VALUES                     *
*****************************************************************
* The dataset needs the following variables (with these names): *
*                                                               *
* study: a string no longer than A8 with the study name         *
* (can be longer, but MATRIX will only print first 8 characters)*
* pvals: one-tailed p-values to be combined                     *
* weights: weighting variable, usually sample sizes             *
*****************************************************************.

* Example #1: homogeneous studies *.

GET 'A:\MetaDataset(I).sav'.
DISPLAY docs.
INCLUDE 'A:\MetaAnalysisOfPvalues.SPS'.

* Example #2: heterogeneous studies *.

GET 'A:\MetaDataset(II).sav'.
DISPLAY docs.
INCLUDE 'A:\MetaAnalysisOfPvalues.SPS'.

* Type of monotherapy used could be a source of heterogeneity *.
FREQUENCIES VARIABLES=monoter.
SORT CASES BY monoter.
SPLIT FILE BY monoter.
INCLUDE 'A:\MetaAnalysisOfPvalues.SPS'.
SPLIT FILE OFF.

* Some interesting hand calculations (info extracted from the output):

* Therapy        K      N     Chihet.   DF(=K-1)   Sig       I
* ----------------------------------------------------------------
* Imipemem      10    1179    17.9864      9      0.0353    49.96%
* Meropemem      5    1397    17.6259      4      0.0015    77.31%
* Ceftazidime    9    1941    23.6347      8      0.0026    66.15%
* Moxalactan     5     421     2.4368      4      0.6560    0%
* Other          5     509     8.1942      4      0.0847    51.18%
* Sum                         69.8780     29      <0.001
* Total         34    5447    78.5972     33      <0.001    58.01%
* Between-groups *             8.7192      4       0.069
--------------------------------------------------------------------
* (*) Total-Sum, both for Chi(78.5972-69.878=8.7192) & DF (33-29=4)

* Conclusion: different monotherapies used are causing a small amount
  of heterogeneity *.

******************************************************************
*              META-ANALYSIS OF BINARY OUTCOMES                  *
******************************************************************
* The dataset needs the following variables (with these names):  *
*                                                                *
* trial: trial number                                            *
* study: a string no longer than A8 with the study name          *
* (can be longer, but MATRIX will only print first 8 characters) *
* evex: Nr of events in treated (or exposed) group               *
* evnex: Nr events in untreated (non exposed) group              *
* totex: Sample size in treated (exposed) group                  *
* totnex: Sample size in treated (exposed) group                 *
* Some extra variables are created by the code, and data will be *
* pseudo-count modified if some zeroes are present               *
******************************************************************.

* Fixed models (homogeneity of studies assumed) & RR as summary measure *.

GET 'A:\MetaDataset(I).sav'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(RR-IV).SPS'.

* Notice the dataset is modified by the code, if you want to run other
  analysis, the dataset must be loaded again, or the extra row&columns erased.

GET 'A:\MetaDataset(I).sav'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(RR-MH).SPS'.

* Fixed models (homogeneity of studies assumed) & RD as summary measure *.

GET 'A:\MetaDataset(I).sav'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(RD-IV).SPS'.

GET 'A:\MetaDataset(I).sav'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(RD-MH).SPS'.

* Fixed models (homogeneity of studies assumed) & OR as summary measure *.

GET 'A:\MetaDataset(I).sav'.

* The following step creates variables caex, coex, canex & conex,
  needed by MetaAnalysisOfBinaryOutcomes(OR-IV) *.
INCLUDE 'A:ForOR.SPS'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(OR-IV).SPS'.

* L'Abb Plot (will not work with SPSS 12) *.

COMPUTE lnodda = ln(caex/coex) .
COMPUTE lnoddb = ln(canex/conex) .
EXECUTE .
WEIGHT BY wi .
GRAPH
  /SCATTERPLOT(BIVAR)=lnoddb WITH lnodda
  /TEMPLATE="A:\L'abbPlot.sct".

* The template will not work with SPSS 12 *.

GET 'A:\MetaDataset(I).sav'.
INCLUDE 'A:ForOR.SPS'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(OR-MH).SPS'.

GET 'A:\MetaDataset(I).sav'.
INCLUDE 'A:ForOR.SPS'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(OR-Peto).SPS'.

* Random effects model (heterogeneous studies) & OR as summary measure *.

GET 'A:\MetaDataset(II).sav'.
INCLUDE 'A:ForOR.SPS'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(OR-DL).SPS'.
DO IF (caex NE 0) & (canex NE 0).
COMPUTE lnodda = ln(caex/coex) .
COMPUTE lnoddb = ln(canex/conex) .
END IF.
EXECUTE .
WEIGHT BY wi .
TEMPORARY.
SELECT IF NOT MISSING(wi).
GRAPH
  /SCATTERPLOT(BIVAR)=lnoddb WITH lnodda
  /TEMPLATE="A:\L'abbPlot.sct".

* Comparison of fixed vs random effects models when some heterogeneity exists.
  but it's not significant *.

GET 'A:\MetaDataset(III).sav'.
DISPLAY docs.

INCLUDE 'A:\MetaAnalysisOfBinOutcomes(RR-IV).SPS'.

* Is heterogeneity related to event rate in control group? *.

COMPUTE corate = 100*evnex / totnex .
EXECUTE .
VAR LABEL corate 'Event rate in control group'.
NONPAR CORR
  /VARIABLES=rr corate
  /PRINT=SPEARMAN TWOTAIL NOSIG.
COMPUTE nobreak=1.
MATCH FILES FILE=* /BY nobreak /LAST=last.
VALUE LABEL last 1 'Summary' 0 'Trial'.
GRAPH
  /SCATTERPLOT(BIVAR)=corate WITH rr BY last
  /TEMPLATE='A:\scatterplot.sct'.

* Assuming some heterogeneity exists: random effects model *.

GET 'A:\MetaDataset(III).sav'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(RR-DL).SPS'.

* Changing the summary measure changes results? *.

GET 'A:\MetaDataset(III).sav'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(RD-IV).SPS'.

GET 'A:\MetaDataset(III).sav'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(RD-DL).SPS'.

* Even more heterogeneity is present *.

COMPUTE corate = 100*evnex / totnex .
EXECUTE .
VAR LABEL corate 'Event rate in control group'.
NONPAR CORR
  /VARIABLES=rd corate
  /PRINT=SPEARMAN TWOTAIL NOSIG.
COMPUTE nobreak=1.
MATCH FILES FILE=* /BY nobreak /LAST=last.
VALUE LABEL last 1 'Summary' 0 'Trial'.
GRAPH /SCATTERPLOT(BIVAR)=corate WITH rd BY last
  /TEMPLATE='A:\scatterplot.sct'.

* Working with summary data (OR & SE(logOR)) instead of counts
  Variables needed are: trial, study, or & selog * .

GET 'A:\MetaDataset(IV).sav'.
DISPLAY docs.

INCLUDE 'A:\MetaAnalysisOfBinOutcomes(SumOR-IV).SPS'.

* Some heterogeneity exists (I=30.5%) *.

GET 'A:\MetaDataset(IV).sav'.
INCLUDE 'A:\MetaAnalysisOfBinOutcomes(SumOR-DL).SPS'.

* Is heterogeneity related to event rate? *.

DESCRIPTIVES
  VARIABLES=nevents cohsize
  /STATISTICS=SUM .
IF (missing(nevents)) nevents = 3144 .
IF (missing(cohsize)) cohsize = 144936 .
COMPUTE rate = 100*nevents / cohsize .
EXECUTE .
VAR LABEL rate 'Event rate in trial population'.
NONPAR CORR
  /VARIABLES=orr rate
  /PRINT=SPEARMAN TWOTAIL NOSIG.
COMPUTE nobreak=1.
MATCH FILES FILE=* /BY nobreak /LAST=last.
VALUE LABEL last 1 'Summary' 0 'Trial'.
GRAPH /SCATTERPLOT(BIVAR)=rate WITH orr BY last
  /TEMPLATE='A:\scatterplot.sct'.

******************************************************************
*              META-ANALYSIS OF CONTINUOUS OUTCOMES              *
******************************************************************
* The dataset needs the following variables (with these names):  *
*                                                                *
* trial: trial number                                            *
* study: a string no longer than A8 with the study name          *
* (can be longer, but MATRIX will only print first 8 characters) *
* mean1: mean in treated (or exposed) group                      *
* mean2: mean in untreated (non exposed) group                   *
* sd1: Std deviation in treated (or exposed) group               *
* sd2: Std deviation in untreated (non exposed) group            *
* n1: Sample size in treated (exposed) group                     *
* n2: Sample size in treated (exposed) group                     *
******************************************************************.

* Unstandardized means (fixed & random effects models) *.

GET 'A:\MetaDataset(V).sav'.
DISPLAY docs.
INCLUDE 'A:\MetaAnalysisOfContOutcomes(WM-IV).SPS'.
* Non significant heterogeneity, but around 44%: Random effects model *.
GET 'A:\MetaDataset(V).sav'.
INCLUDE 'A:\MetaAnalysisOfContOutcomes(WM-DL).SPS'.

* Standardized means (Hedges' g) *.

GET 'A:\MetaDataset(VI).sav'.
DISPLAY docs.
* Means are measured in different scales, standardizing is necessary *.
INCLUDE 'A:\MetaAnalysisOfContOutcomes(G-IV).SPS'.

* Summary data (Cohen's d as input) with heterogeneous trials:
  The following variables are needed: trial, study, cohend, n1 & n2 *.

GET 'A:\MetaDataset(XI).sav'.
INCLUDE 'A:\MetaAnalysisOfContOutcomes(SumG-DL).SPS'.

******************************************************************
*           META-ANALYSIS OF CORRELATION COEFICIENTS             *
******************************************************************
* The dataset needs the following variables (with these names):  *
*                                                                *
* trial: trial number                                            *
* study: a string no longer than A8 with the study name          *
* (can be longer, but MATRIX will only print first 8 characters) *
* n: Sample sizes                                                *
* cor: correlation coeficients                                   *
******************************************************************.


GET 'A:\MetaDataset(VII).sav'.
DISPLAY docs.

* Funnel plot: detecting publication bias *.
GRAPH /SCATTERPLOT(BIVAR)=cor WITH n
  /TEMPLATE='A:\funnel.sct'.

* Hedges-Olkin fixed effects model *.

INCLUDE 'A:\MetaAnalysisOfCorrCoef(HO-IV).SPS'.

* Schmidt-Hunter method with homogeneous studies *.

GET 'A:\MetaDataset(VII).sav'.
INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.

* Hedges-Olkin random effects model *.

GET 'A:\MetaDataset(VIII).sav'.
DISPLAY docs.

INCLUDE 'A:\MetaAnalysisOfCorrCoef(HO-DL).SPS'.

* Schmidt-Hunter method with heterogeneous studies *.

GET 'A:\MetaDataset(VIII).sav'.
INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.

* Why studies are heterogeneous?: *.

* We don't have moderator variables to explore *.
* Empirical subsets (trying to find homogeneous subgroups) *.
EXAMINE VARIABLES=cor
  /PLOT STEMLEAF
  /STATISTICS NONE
  /NOTOTAL.

* Seems that correlations cluster in two groups *.
QUICK CLUSTER cor
  /CRITERIA= CLUSTER(2)
  /METHOD=CLASIFFY
  /SAVE CLUSTER(subset2)
  /PRINT NONE.

* Schmidt-Hunter analysis within subgroups *.
SORT CASES BY subset2 .
SPLIT FILE BY subset2 .
INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.
SPLIT FILE OFF.

* Schmidt-Hunter analysis with moderator variables *.

GET 'A:\MetaDataset(IX).sav'.
DISPLAY docs.

INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.

SORT CASES BY deftype .
SPLIT FILE BY deftype .
INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.
SPLIT FILE OFF.

SORT CASES BY defense .
SPLIT FILE BY defense .
INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.
SPLIT FILE OFF.

SORT CASES BY fitness .
SPLIT FILE BY fitness .
INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.
SPLIT FILE OFF.

SORT CASES BY herbivor .
SPLIT FILE BY herbivor .
INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.
SPLIT FILE OFF.

SORT CASES BY control .
SPLIT FILE BY control .
INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.
SPLIT FILE OFF.

SORT CASES BY defense herbivor control .
SPLIT FILE BY defense herbivor control .
INCLUDE 'A:\MetaAnalysisOfCorrCoef(SH).SPS'.
SPLIT FILE OFF.